#|

PHASE 4 - SOURCE
These files are used to alter the workspace. Often, these files are new features. They are loaded after initial display is completely prepared but before it is seen and before any -f or dde files are read.


FILENAMES
Please use this naming convention for files in the update directory (where xxx is the original file name, when possible, and -mm-dd-yy is month-day-year of fix)

xxx-slt-mm-dd-yy.lsp  slot changes
xxx-fix-mm-dd-yy.lsp  bug fixes
xxx-bet-mm-dd-yy.lsp  betterments
xxx-new-mm-dd-yy.lsp  new features
xxx-mod-mm-dd-yy.lsp  modifications


SUBDIRECTORY NAME
Please name the subdirectory to identify the date of release of the changes. You must create a variable *update-subpath* whose value is a string which names the subdirectory. Do this with the following statement, substituting your subdirectory name (note use of back-quote and comma):

(setf *update-subpath* (make-pathname :directory `(:relative ,*update-path* "Sep23-2002")))

LOADING FILES
You should use the following statements to load files from the update subdirectory, substituting the appropriate filenames. Please include a comment explaining the update.

(mapcar #'(lambda (filename) (load (strcat *update-subpath* filename)))
        (list "datasmry-bet-09-03-02.lsp" ;changes about-these-data
              "datatype-fix-09-03-02.lsp" ;remove "checking for missing values"
              ))
|#


(setf *update-subpath* (make-pathname :directory `(:relative ,*update-path* "Missing-January2004")))

(mapcar #'(lambda (filename) (load (strcat *update-subpath* filename)))
        (list "missd0.lsp" ;
              "missd1.lsp" ;
              "missd2.lsp"
              "missd3.lsp"
              "missd4.lsp"
              "missd5.lsp"
              "missd6.lsp"
              "missd7.lsp"
              "missd8.lsp"
              "missd9.lsp"
              "missd10.lsp"
              "vismiss.lsp"
              "diamonmiss4.lsp"
              "miputatio-plot.lsp"
              ))

(setf *update-subpath* (make-pathname :directory `(:relative ,*update-path* "scatter-January2004")))

(mapcar #'(lambda (filename) (load (strcat *update-subpath* filename)))
        (list "graphic1.lsp" ;
              "regcolors.lsp" ;
              "Scatter2.lsp"
              "Scatter3.lsp"
              "Scatter4.lsp"
              ))


(setf *update-subpath* (strcat *update-path* "pdf-18-4-2005\\"))
#|fixes a bug with the pdfs of scatterplots. Some points will not print in standard version of this file. I have to check the rest of files. This version works fine.|#

(mapcar #'(lambda (filename) (load (strcat *update-subpath* filename)))
        (list "pdfScat.lsp"
              "boxpdf.lsp"
              ))

#|Disconnects the process that runs continuously|#

(send *startup-manager* :idle-on nil)

